/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.ClientTickHandler;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.player.GuiMailmanWrite;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IResourceData;
import noppes.npcs.client.util.ResourceData;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.util.Util;

public class GuiMailbox
extends GuiNPCInterface
implements IGuiData,
ICustomScrollListener,
GuiYesNoCallback {
    public static final ResourceLocation icons = new ResourceLocation("customnpcs", "textures/gui/mail/icons.png");
    private static final ResourceLocation mBox = new ResourceLocation("customnpcs", "textures/gui/mail/box_empty.png");
    private static final ResourceLocation mDoor = new ResourceLocation("customnpcs", "textures/gui/mail/box_door.png");
    private static final ResourceLocation mList = new ResourceLocation("customnpcs", "textures/gui/mail/box_list.png");
    private final Map<String, PlayerMail> scrollData = new HashMap<String, PlayerMail>();
    private GuiCustomScroll scroll;
    private PlayerMail selected;
    private int closeType;
    private int step;
    private int tick;
    private int millyTick;
    private final Random rnd = new Random();

    public GuiMailbox() {
        this.xSize = 192;
        this.ySize = 236;
        NoppesUtilPlayer.sendData(EnumPlayerPacket.MailGet, new Object[0]);
        ClientTickHandler.checkMails = true;
        this.tick = 30;
        this.millyTick = 30;
        this.step = 0;
        this.closeType = 0;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        GuiMailmanWrite.parent = this;
        switch (button.getID()) {
            case 0: {
                if (this.selected == null) {
                    return;
                }
                GuiMailmanWrite.mail = this.selected;
                this.step = 4;
                this.tick = 15;
                this.millyTick = 15;
                this.closeType = 2;
                break;
            }
            case 1: {
                this.step = 4;
                this.tick = 15;
                this.millyTick = 15;
                this.closeType = 1;
                break;
            }
            case 2: {
                if (this.selected == null) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, this.scroll.getSelected(), new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 0);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 3: {
                if (ClientProxy.playerData.mailData.playerMails.isEmpty()) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("mailbox.name", new Object[0]).func_150254_d() + ":", new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 1);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 4: {
                if (ClientProxy.playerData.mailData.playerMails.isEmpty()) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("mailbox.name", new Object[0]).func_150254_d() + ":", new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 2);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 5: {
                this.step = 4;
                this.tick = 15;
                this.millyTick = 15;
                this.closeType = 0;
            }
        }
    }

    public void func_73878_a(boolean flag, int id) {
        NoppesUtil.openGUI((EntityPlayer)this.player, this);
        if (!flag) {
            return;
        }
        if (id == 0 && this.selected != null) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.MailDelete, this.selected.timeWhenReceived, this.selected.sender);
            this.selected = null;
        } else if (id == 1) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.MailDelete, 0L);
            this.selected = null;
        } else if (id == 2) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.MailDelete, -1L);
            this.selected = null;
        }
        MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:mail.delete", (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v, 1.0f, 0.9f + 0.2f * this.rnd.nextFloat());
    }

    private void drawMailBox(float u, float v) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)u, (float)v, (float)0.0f);
        this.field_146297_k.func_110434_K().func_110577_a(mBox);
        this.func_73729_b(0, 0, 0, 0, 192, 236);
        if (!this.scrollData.isEmpty()) {
            this.field_146297_k.func_110434_K().func_110577_a(mList);
            this.func_73729_b(8, 45, 0, 0, 176, 156);
        }
        if (this.step == 3) {
            this.field_146297_k.func_110434_K().func_110577_a(mDoor);
            this.func_73729_b(-5, 44, 181, 0, 7, 158);
        }
        GlStateManager.func_179121_F();
        if (this.scroll != null) {
            this.scroll.guiLeft = (int)u + 9;
            this.scroll.guiTop = (int)v + 45;
        }
        if (this.getLabel(0) != null && this.getLabel(0).isEnabled()) {
            GuiNpcLabel l = (GuiNpcLabel)this.getLabel(0);
            l.x = (int)u + 95 - l.width / 2;
            l.y = (int)v + 11;
        }
        block8: for (int i = 0; i < 6; ++i) {
            if (this.getButton(i) == null) {
                return;
            }
            GuiNpcButton b = (GuiNpcButton)this.getButton(i);
            b.setEnabled(this.step == 3);
            switch (i) {
                case 0: {
                    b.field_146128_h = (int)u + 8;
                    b.field_146129_i = (int)v + 202;
                    b.setEnabled(this.step == 3 && this.selected != null);
                    continue block8;
                }
                case 1: {
                    b.field_146128_h = (int)u + 67;
                    b.field_146129_i = (int)v + 202;
                    b.setEnabled(this.step == 3);
                    continue block8;
                }
                case 2: {
                    b.field_146128_h = (int)u + 126;
                    b.field_146129_i = (int)v + 202;
                    b.setEnabled(this.step == 3 && this.selected != null);
                    continue block8;
                }
                case 3: {
                    b.field_146128_h = (int)u + 8;
                    b.field_146129_i = (int)v + 218;
                    b.setEnabled(this.step == 3 && this.scroll != null && !this.scroll.getList().isEmpty());
                    continue block8;
                }
                case 4: {
                    b.field_146128_h = (int)u + 67;
                    b.field_146129_i = (int)v + 218;
                    b.setEnabled(this.step == 3 && this.scroll != null && !this.scroll.getList().isEmpty());
                    continue block8;
                }
                case 5: {
                    b.field_146128_h = (int)u + 126;
                    b.field_146129_i = (int)v + 218;
                    b.setEnabled(this.step == 3);
                }
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tick >= 0) {
            float part;
            float cos;
            if (this.tick == 0) {
                partialTicks = 0.0f;
            }
            if ((cos = (float)Math.cos(90.0 * (double)(part = (float)this.tick + partialTicks) / (double)this.millyTick * Math.PI / 180.0)) < 0.0f) {
                cos = 0.0f;
            } else if (cos > 1.0f) {
                cos = 1.0f;
            }
            switch (this.step) {
                case 0: {
                    if (this.tick == this.millyTick) {
                        MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:mail.movement", (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v, 1.0f, 0.75f + 0.25f * this.rnd.nextFloat());
                    }
                    this.drawMailBox(this.guiLeft, (float)this.guiTop + (1.0f - cos) * 236.0f);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)this.guiLeft, (float)((float)this.guiTop + (1.0f - cos) * 236.0f), (float)2.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(mDoor);
                    this.func_73729_b(8, 44, 0, 0, 178, 158);
                    GlStateManager.func_179121_F();
                    if (this.tick != 0) break;
                    this.step = 1;
                    this.tick = 20;
                    this.millyTick = 20;
                    MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:mail.open.door", (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v, 1.0f, 0.75f + 0.25f * this.rnd.nextFloat());
                    GlStateManager.func_179084_k();
                    break;
                }
                case 1: {
                    this.drawMailBox(this.guiLeft, this.guiTop);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)this.guiLeft - cos * 193.0f), (float)this.guiTop, (float)2.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(mDoor);
                    this.func_73729_b(8, 44, 0, 0, 178, 158);
                    GlStateManager.func_179121_F();
                    if (this.tick != 0) break;
                    this.step = 2;
                    this.tick = 15;
                    this.millyTick = 15;
                    GlStateManager.func_179084_k();
                    break;
                }
                case 2: {
                    this.drawMailBox(this.guiLeft, this.guiTop);
                    float s = 1.0f - cos;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)this.guiLeft - 7.0f - 186.0f * s), (float)this.guiTop, (float)2.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(mDoor);
                    GlStateManager.func_179152_a((float)s, (float)1.0f, (float)1.0f);
                    this.func_73729_b(8, 44, 0, 0, 178, 158);
                    this.func_73729_b(183, 44, 178, 0, 3, 158);
                    GlStateManager.func_179121_F();
                    s = cos;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)this.guiLeft - 7.0f), (float)this.guiTop, (float)2.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(mDoor);
                    GlStateManager.func_179152_a((float)s, (float)1.0f, (float)1.0f);
                    this.func_73729_b(0, 44, 181, 0, 7, 158);
                    GlStateManager.func_179121_F();
                    if (this.tick != 0) break;
                    this.step = 3;
                    this.millyTick = 0;
                    GlStateManager.func_179084_k();
                    break;
                }
                case 4: {
                    if (this.tick == this.millyTick) {
                        MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:mail.close.door", (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v, 1.0f, 0.75f + 0.25f * this.rnd.nextFloat());
                    }
                    this.drawMailBox(this.guiLeft, this.guiTop);
                    float s = cos;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)this.guiLeft - 7.0f - 186.0f * s), (float)this.guiTop, (float)2.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(mDoor);
                    GlStateManager.func_179152_a((float)s, (float)1.0f, (float)1.0f);
                    this.func_73729_b(8, 44, 0, 0, 178, 158);
                    this.func_73729_b(183, 44, 178, 0, 3, 158);
                    GlStateManager.func_179121_F();
                    s = 1.0f - cos;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)this.guiLeft - 7.0f), (float)this.guiTop, (float)2.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(mDoor);
                    GlStateManager.func_179152_a((float)s, (float)1.0f, (float)1.0f);
                    this.func_73729_b(0, 44, 181, 0, 7, 158);
                    GlStateManager.func_179121_F();
                    if (this.tick != 0) break;
                    this.step = 5;
                    this.tick = 20;
                    this.millyTick = 20;
                    GlStateManager.func_179084_k();
                    break;
                }
                case 5: {
                    this.drawMailBox(this.guiLeft, this.guiTop);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)this.guiLeft - (1.0f - cos) * 193.0f), (float)this.guiTop, (float)2.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(mDoor);
                    this.func_73729_b(8, 44, 0, 0, 178, 158);
                    GlStateManager.func_179121_F();
                    if (this.tick != 0) break;
                    this.step = 6;
                    this.tick = 30;
                    this.millyTick = 30;
                    MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:mail.movement", (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v, 1.0f, 0.75f + 0.25f * this.rnd.nextFloat());
                    GlStateManager.func_179084_k();
                    break;
                }
                case 6: {
                    this.drawMailBox(this.guiLeft, (float)this.guiTop + cos * 236.0f);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)this.guiLeft, (float)((float)this.guiTop + cos * 236.0f), (float)2.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(mDoor);
                    this.func_73729_b(8, 44, 0, 0, 178, 158);
                    GlStateManager.func_179121_F();
                    if (this.tick != 0) break;
                    this.step = 0;
                    this.tick = 30;
                    this.millyTick = 30;
                    if (this.closeType == 1) {
                        NoppesUtilPlayer.sendData(EnumPlayerPacket.MailboxOpenMail, 0L, "", 1, 1);
                    } else if (this.closeType == 2 && this.selected != null) {
                        if (!this.selected.beenRead) {
                            this.selected.beenRead = true;
                            PlayerMail mail = ClientProxy.playerData.mailData.get(this.selected);
                            if (mail != null) {
                                mail.beenRead = true;
                                ClientTickHandler.checkMails = true;
                            }
                            NoppesUtilPlayer.sendData(EnumPlayerPacket.MailRead, this.selected.timeWhenReceived, this.selected.sender);
                        }
                        NoppesUtilPlayer.sendData(EnumPlayerPacket.MailboxOpenMail, this.selected.timeWhenReceived, this.selected.sender, 0, 0, 0);
                        this.selected = null;
                        this.scroll.setSelect(-1);
                    }
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179121_F();
                    this.close();
                    return;
                }
            }
            --this.tick;
        } else {
            this.drawMailBox(this.guiLeft, this.guiTop);
        }
        GlStateManager.func_179121_F();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.step != 3 || this.hasSubGui() || !CustomNpcs.ShowDescriptions) {
            return;
        }
        ArrayList<String> hover = new ArrayList<String>();
        if (this.scroll != null && this.scroll.hover > -1) {
            PlayerMail mail = this.scrollData.get(this.scroll.getList().get(this.scroll.hover));
            hover.add("\u00a77" + new TextComponentTranslation("mailbox.sender", new Object[0]).func_150254_d() + '\u00a7' + "7 \"" + '\u00a7' + "r" + mail.sender + '\u00a7' + "7\"");
            long timeWhenReceived = System.currentTimeMillis() - mail.timeWhenReceived - mail.timeWillCome;
            if (CustomNpcs.MailTimeWhenLettersWillBeDeleted > 0) {
                long timeToRemove = (long)CustomNpcs.MailTimeWhenLettersWillBeDeleted * 86400000L - timeWhenReceived;
                if (timeToRemove < 0L) {
                    NoppesUtilPlayer.sendData(EnumPlayerPacket.MailDelete, mail.timeWhenReceived, mail.sender);
                    return;
                }
                hover.add("\u00a77" + new TextComponentTranslation("mailbox.when.removed", new Object[]{Util.instance.ticksToElapsedTime(timeToRemove / 50L, false, true, false)}).func_150254_d());
            }
            if (mail.beenRead) {
                hover.add("\u00a7a" + new TextComponentTranslation("mailbox.when.read", new Object[0]).func_150254_d());
            } else {
                hover.add("\u00a77" + new TextComponentTranslation("mailbox.when.received", new Object[]{Util.instance.ticksToElapsedTime(timeWhenReceived / 50L, false, true, false)}).func_150254_d());
            }
        }
        if (!hover.isEmpty()) {
            this.setHoverText(hover);
            this.drawHoverText(null, new Object[0]);
        }
    }

    @Override
    public void func_73866_w_() {
        String key;
        super.func_73866_w_();
        ClientTickHandler.checkMails = true;
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(165, 154);
        }
        this.scroll.guiLeft = this.guiLeft + 9;
        this.scroll.guiTop = this.guiTop + 45;
        String select = this.scroll.getSelected();
        this.scrollData.clear();
        ArrayList<PlayerMail> listR = new ArrayList<PlayerMail>();
        ArrayList<PlayerMail> listN = new ArrayList<PlayerMail>();
        long time = System.currentTimeMillis();
        for (PlayerMail mail : ClientProxy.playerData.mailData.playerMails) {
            if (time - mail.timeWhenReceived < mail.timeWillCome) continue;
            if (mail.beenRead) {
                listR.add(mail);
                continue;
            }
            listN.add(mail);
        }
        listR.sort((o1, o2) -> {
            if (o1.timeWhenReceived == o2.timeWhenReceived) {
                return 0;
            }
            return o1.timeWhenReceived > o2.timeWhenReceived ? -1 : 1;
        });
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        ArrayList<IResourceData> prefixes = new ArrayList<IResourceData>();
        int i = 1;
        for (PlayerMail mail : listN) {
            key = "\u00a78" + i + ": " + '\u00a7' + "r\"" + new TextComponentTranslation(mail.title, new Object[0]).func_150254_d() + "\"";
            list.add(key);
            this.scrollData.put(key, mail);
            ResourceData rd = new ResourceData(icons, mail.getRansom() > 0 ? 96 : (mail.returned ? 128 : 0), 0, 32, 32);
            rd.tH = -3.0f;
            prefixes.add(rd);
            colors.add(CustomNpcs.LableColor.getRGB());
            ++i;
        }
        for (PlayerMail mail : listR) {
            key = "\u00a78" + i + ": " + '\u00a7' + "r\"" + new TextComponentTranslation(mail.title, new Object[0]).func_150254_d() + "\"";
            list.add(key);
            this.scrollData.put(key, mail);
            boolean isEmpty = true;
            for (ItemStack stack : mail.items) {
                if (stack.func_190926_b()) continue;
                isEmpty = false;
                break;
            }
            ResourceData rd = new ResourceData(icons, mail.getRansom() > 0 ? 96 : (isEmpty ? 64 : 32), 0, 32, 32);
            rd.tH = -3.0f;
            prefixes.add(rd);
            colors.add(CustomNpcs.LableColor.getRGB());
            ++i;
        }
        this.scroll.clear();
        this.scroll.setListNotSorted(list);
        this.scroll.setPrefixes(prefixes);
        this.scroll.setColors(colors);
        this.scroll.colorBack = 0;
        if (select != null && !select.isEmpty()) {
            this.scroll.setSelected(select);
        }
        this.addScroll(this.scroll);
        String title = new TextComponentTranslation("mailbox.name", new Object[0]).func_150254_d();
        int x = (this.xSize - this.field_146289_q.func_78256_a(title)) / 2;
        this.addLabel(new GuiNpcLabel(0, title, this.guiLeft + x, this.guiTop + 11));
        this.getLabel(0).setColor(CustomNpcs.MainColor.getRGB());
        x = this.guiLeft + 8;
        int y = this.guiTop + 202;
        GuiNpcButton button = new GuiNpcButton(0, x, y, 58, 14, "mailbox.read");
        button.texture = icons;
        button.txrY = 96;
        button.setHoverText("mailbox.hover.read", new Object[0]);
        button.setEnabled(this.selected != null);
        this.addButton(button);
        button = new GuiNpcButton(1, x + 59, y, 58, 14, "mailbox.write");
        button.texture = icons;
        button.txrY = 96;
        button.setHoverText("mailbox.hover.write", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, x + 118, y, 58, 14, "gui.remove");
        button.texture = icons;
        button.txrY = 96;
        button.setHoverText("mailbox.hover.del", new Object[0]);
        button.setEnabled(this.selected != null);
        this.addButton(button);
        button = new GuiNpcButton(3, x, y += 16, 58, 14, "gui.remove.all");
        button.texture = icons;
        button.txrY = 96;
        button.setHoverText("mailbox.hover.delall", new Object[0]);
        button.setEnabled(!list.isEmpty());
        this.addButton(button);
        button = new GuiNpcButton(4, x + 59, y, 58, 14, "gui.clear");
        button.texture = icons;
        button.txrY = 96;
        button.setHoverText("mailbox.hover.clear", new Object[0]);
        button.setEnabled(!list.isEmpty());
        this.addButton(button);
        button = new GuiNpcButton(5, x + 118, y, 58, 14, "display.hover.X");
        button.texture = icons;
        button.txrY = 96;
        button.setHoverText("hover.exit", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (this.step == 3 && i == 1 || this.isInventoryKey(i)) {
            this.step = 4;
            this.tick = 15;
            this.millyTick = 15;
            this.closeType = 0;
        }
    }

    @Override
    public void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        this.scroll.func_73864_a(i, j, k);
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.selected = this.scrollData.get(scroll.getSelected());
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        if (this.selected == null) {
            return;
        }
        GuiMailmanWrite.parent = this;
        GuiMailmanWrite.mail = this.selected;
        this.step = 4;
        this.tick = 15;
        this.millyTick = 15;
        this.closeType = 2;
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        ClientProxy.playerData.mailData.loadNBTData(compound);
        this.selected = null;
        this.func_73866_w_();
    }
}

